// *Written by:* 		  Andr Anundsen
// *Purpose:*    		  Run ADF-test on the second differences of the series 
// *Date of last update:* 11/12-2015
second_diff()
{
model = new PcGive();
model.Load(root | "Appendix/OxCodes for individual unit root tests/Data/Data.csv");      
model.Deterministic(3); 
tval_second_diff          = zeros(N,variables);
lags_second_diff          = zeros(N,variables);

decl i, j, l;
for(l = 0; l <= variables - 1; l ++)
{
// To collect t-values for different lags, decide on the optimal lag truncation and collect the t-adf statistic
t_second_diff             = zeros(N,max_lag + 1);

for (i = firsters; i <= lasters;  i ++)											 			   
{
if(Ddata[l][118][i] == .NaN)
{
tval_second_diff[i][l] = .NaN;
}
else
{
println("This is test of second differences for area ", i); 
model.DeSelect();

model.Renew(D3data[l][0:][i],"D3var"); 
model.Select(Y_VAR, {"D3var", 0, max_lag});
model.Renew(D2data[l][0:][i],"D2var"); 
model.Select(X_VAR, {"D2var", 1, 1});
model.Select(X_VAR, {"Constant", 0, 0});
if(seasons)
{
model.Select(X_VAR, {"CSeasonal"  , 0, 2});															   
}
model.SetSelSample(start_year, start_quarter, end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
decl extra          = total_obs - model.GetcT();
decl end = (total_obs - 1 - model.GetSelEnd());

model.DeSelect();

model.Renew(D3data[l][0:][i],"D3var"); 
model.Select(Y_VAR, {"D3var", 0, 0});
model.Renew(D2data[l][0:][i],"D2var"); 
model.Select(X_VAR, {"D2var", 1, 1});

model.Select(X_VAR, {"Constant", 0, 0});
if(seasons)
{
model.Select(X_VAR, {"CSeasonal"  , 0, 2});															   
}
model.SetSelSample(start_year, start_quarter + (extra - end), end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
decl tval  = fabs(model.GetFreePar() ./ model.GetStdErr()); 

if(seasons)
{
t_second_diff[i][0] = tval[model.GetFreeParCount() - 4 - 1][]; 
}
else
{
t_second_diff[i][0] = tval[model.GetFreeParCount() - 1 - 1][]; 
}


// Number of lags in the models. Increase by one for each stage of j loop
for(j = 1; j <= max_lag; j ++)
{
model.Select(X_VAR, {"D3var", j, j});

model.SetSelSample(start_year, start_quarter + (extra - end), end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
tval  = fabs(model.GetFreePar() ./ model.GetStdErr()); 
if(seasons)
{
t_second_diff[i][j] = tval[model.GetFreeParCount() - 4 - 1][]; 
}
else
{
t_second_diff[i][j] = tval[model.GetFreeParCount() - 1 - 1][]; 
}
}

// Choosing the optimal lag truncation of the endogenous variables

if(max_lag == 8)
{
if(t_second_diff[i][8] >= t_crit_val)
{
lags_second_diff[i][l] = 8; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] >= t_crit_val)
{
lags_second_diff[i][l] = 7; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] >= t_crit_val)
{
lags_second_diff[i][l] = 6; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] >= t_crit_val)
{
lags_second_diff[i][l] = 5; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] >= t_crit_val)
{
lags_second_diff[i][l] = 4; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] >= t_crit_val)
{
lags_second_diff[i][l] = 3; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] >= t_crit_val)
{
lags_second_diff[i][l] = 2; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] >= t_crit_val)
{
lags_second_diff[i][l] = 1; 
}
if(t_second_diff[i][8] < t_crit_val && t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] < t_crit_val)
{
lags_second_diff[i][l] = 0; 
}
}

if(max_lag == 7)
{
if(t_second_diff[i][7] >= t_crit_val)
{
lags_second_diff[i][l] = 7; 
}
if(t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] >= t_crit_val)
{
lags_second_diff[i][l] = 6; 
}
if(t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] >= t_crit_val)
{
lags_second_diff[i][l] = 5; 
}
if(t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] >= t_crit_val)
{
lags_second_diff[i][l] = 4; 
}
if(t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] >= t_crit_val)
{
lags_second_diff[i][l] = 3; 
}
if(t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] >= t_crit_val)
{
lags_second_diff[i][l] = 2; 
}
if(t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] >= t_crit_val)
{
lags_second_diff[i][l] = 1; 
}
if(t_second_diff[i][7] < t_crit_val && t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] < t_crit_val)
{
lags_second_diff[i][l] = 0; 
}
}


if(max_lag == 6)
{
if(t_second_diff[i][6] >= t_crit_val)
{
lags_second_diff[i][l] = 6; 
}
if(t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] >= t_crit_val)
{
lags_second_diff[i][l] = 5; 
}
if(t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] >= t_crit_val)
{
lags_second_diff[i][l] = 4; 
}
if(t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] >= t_crit_val)
{
lags_second_diff[i][l] = 3; 
}
if(t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] >= t_crit_val)
{
lags_second_diff[i][l] = 2; 
}
if(t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] >= t_crit_val)
{
lags_second_diff[i][l] = 1; 
}
if(t_second_diff[i][6] < t_crit_val && t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] < t_crit_val)
{
lags_second_diff[i][l] = 0; 
}
}

if(max_lag == 5)
{
if(t_second_diff[i][5] >= t_crit_val)
{
lags_second_diff[i][l] = 5; 
}
if(t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] >= t_crit_val)
{
lags_second_diff[i][l] = 4; 
}
if(t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] >= t_crit_val)
{
lags_second_diff[i][l] = 3; 
}
if(t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] >= t_crit_val)
{
lags_second_diff[i][l] = 2; 
}
if(t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] >= t_crit_val)
{
lags_second_diff[i][l] = 1; 
}
if(t_second_diff[i][5] < t_crit_val && t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] < t_crit_val)
{
lags_second_diff[i][l] = 0; 
}
}


if(max_lag == 4)
{
if(t_second_diff[i][4] >= t_crit_val)
{
lags_second_diff[i][l] = 4; 
}
if(t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] >= t_crit_val)
{
lags_second_diff[i][l] = 3; 
}
if(t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] >= t_crit_val)
{
lags_second_diff[i][l] = 2; 
}
if(t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] >= t_crit_val)
{
lags_second_diff[i][l] = 1; 
}
if(t_second_diff[i][4] < t_crit_val && t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] < t_crit_val)
{
lags_second_diff[i][l] = 0; 
}
}


if(max_lag == 3)
{
if(t_second_diff[i][3] >= t_crit_val)
{
lags_second_diff[i][l] = 3; 
}
if(t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] >= t_crit_val)
{
lags_second_diff[i][l] = 2; 
}
if(t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] >= t_crit_val)
{
lags_second_diff[i][l] = 1; 
}
if(t_second_diff[i][3] < t_crit_val && t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] < t_crit_val)
{
lags_second_diff[i][l] = 0; 
}
}


if(max_lag == 2)
{
if(t_second_diff[i][2] >= t_crit_val)
{
lags_second_diff[i][l] = 2; 
}
if(t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] >= t_crit_val)
{
lags_second_diff[i][l] = 1; 
}
if(t_second_diff[i][2] < t_crit_val && t_second_diff[i][1] < t_crit_val)
{
lags_second_diff[i][l] = 0; 
}
}

model.DeSelect();
model.Renew(D3data[l][0:][i],"D3var"); 
model.Select(Y_VAR, {"D3var", 0, lags_second_diff[i][l]});
model.Renew(D2data[l][0:][i],"D2var"); 
model.Select(X_VAR, {"D2var", 1, 1});

model.Select(X_VAR, {"Constant", 0, 0});
if(seasons)
{
model.Select(X_VAR, {"CSeasonal"  , 0, 2});															   
}
model.SetSelSample(start_year, start_quarter + (extra - end), end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
tval  = model.GetFreePar() ./ model.GetStdErr(); 
if(seasons)
{
tval_second_diff[i][l] = tval[model.GetFreeParCount() - 4 - 1][]; 
}
else
{
tval_second_diff[i][l] = tval[model.GetFreeParCount() - 1 - 1][]; 
}
}
}
}
return TRUE;
}